% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line.R
\name{lineServer}
\alias{lineServer}
\title{lineServer: shiny module server for lineplot.}
\usage{
lineServer(id, data, data_label, data_varStruct = NULL, nfactor.limit = 10)
}
\arguments{
\item{id}{id}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}
}
\value{
Shiny module server for lineplot.
}
\description{
Shiny module server for lineplot.
}
\details{
Shiny module server for lineplot.
}
\examples{
library(shiny)
library(ggplot2)
library(ggpubr)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      lineUI("line")
    ),
    mainPanel(
      plotOutput("line_plot"),
      ggplotdownUI("line")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_line <- lineServer("line",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$line_plot <- renderPlot({
    print(out_line())
  })
}
}
