% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{scatterUI}
\alias{scatterUI}
\title{scatterUI: shiny module UI for scatterplot}
\usage{
scatterUI(id, label = "scatterplot")
}
\arguments{
\item{id}{id}

\item{label}{label}
}
\value{
Shiny module UI for scatterplot
}
\description{
Shiny module UI for scatterplot
}
\details{
Shiny module UI for scatterplot
}
\examples{
library(shiny)
library(ggplot2)
library(ggpubr)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      scatterUI("scatter")
    ),
    mainPanel(
      optionUI("scatter"),
      plotOutput("scatter_plot"),
      ggplotdownUI("scatter")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_scatter <- scatterServer("scatter",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$scatter_plot <- renderPlot({
    print(out_scatter())
  })
}
}
