% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{json_mutate}
\alias{json_mutate}
\title{Update values}
\usage{
json_mutate(x, ...)
}
\arguments{
\item{x}{A JSON vector.}

\item{...}{Name-value pairs. The name is the JSON path (without leading "$").}
}
\value{
A \code{json2} vector similar to \code{x} with the components modified as
specified in \code{...}.
}
\description{
Update values
}
\examples{
x_na <- c('{"a": 11, "b": {"x": 12}}', NA, '{"a": 21, "b": {"x": 22}}')
# update with different values
json_mutate(x_na, .a = 1:3)

# NA is translated to null
json_mutate(x_na, .a = 1:3, .b.x = NA)

# create new keys
json_mutate(x_na, .c = 0, .d.x = c("a", "b", "c"))
}
