% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram.R
\name{jst_subset_ngrams}
\alias{jst_subset_ngrams}
\title{Define a subset of ngrams}
\usage{
jst_subset_ngrams(zip_archives, ngram_type, selection, by = file_name)
}
\arguments{
\item{zip_archives}{A character vector of one or multiple zip-files.}

\item{ngram_type}{One of \code{"ngram1"}, \code{"ngram2"} or \code{"ngram3"}}

\item{selection}{A data.frame with the articles/books which are to be
selected.}

\item{by}{A column name for matching.}
}
\value{
A list of zip-locations which can be read via \code{\link[=jst_get_ngram]{jst_get_ngram()}}.
}
\description{
This function helps in defining a subset of ngram files which should be
imported, since importing all ngrams at once can be very expensive (in
terms of cpu and memory).
}
\examples{
# create sample output
tmp <- tempdir()
jst_import_zip(jst_example("pseudo_dfr.zip"),
               import_spec = jst_define_import(book = jst_get_book),
               out_file = "test", out_path = tmp)

# re-import as our selection for which we would like to import ngrams
selection <- jst_re_import(file.path(tmp, 
                                     "test_book_chapter_jst_get_book-1.csv"))

# get location of file
zip_loc <- jst_subset_ngrams(jst_example("pseudo_dfr.zip"), "ngram1",
                             selection) 

# import ngram
jst_get_ngram(zip_loc[[1]])
unlink(tmp)
}
