% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{find_book}
\alias{find_book}
\title{Extract meta information for books}
\usage{
find_book(file_path)
}
\arguments{
\item{file_path}{A \code{.xml}-file for a book or research report.}
}
\value{
A \code{tibble} containing the extracted meta-data with the following
columns:
\itemize{
\item basename_id \emph{(chr)}: The filename of the original .xml-file. Can be used
for joining with other data for the same file.
\item discipline \emph{(chr)}: The discipline from the discipline names used on JSTOR.
\item book_id \emph{(chr)}: The book id of type "jstor", which is not a registered
DOI.
\item book_title \emph{(chr)}: The title of the book.
\item book_subtitle \emph{(chr)}: The subtitle of the book.
\item pub_day \emph{(int)}: Publication day, if specified.
\item pub_month \emph{(int)}: Publication month, if specified.
\item pub_year \emph{(int)}: Year of publication.
\item isbn \emph{(chr)}: One or more entries for the book's ISBN. If two or more,
separated by \code{"; "}.
\item publisher_name \emph{(chr)}: The name of the publisher.
\item publisher_loc \emph{(chr)}: The location of the publisher.
\item n_pages \emph{(int)}: The number of pages.
\item language \emph{(chr)}: The language of the book.
}

A note about publication dates: always the first entry is being extracted,
which should correspond to the oldest date, in case there is more than one
date.
}
\description{
\code{find_book()} extracts meta-data from JSTOR-XML files for book chapters.
}
\examples{
find_book(jstor_example("sample_book.xml"))
}
