% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{jtools_colors}
\alias{jtools_colors}
\title{Color palettes in \code{jtools} functions}
\description{
\code{jtools} combines several options into the \code{color.class}
argument in plotting functions.
}
\details{
The argument to \code{color.class} in functions like \code{interact_plot},
\code{cat_plot}, \code{plot_coefs}, and others is very flexible but may also
cause confusion.

If you provide an argument of length 1, it is assumed that you are naming
a palette. \code{jtools} provides 6 color palettes design for qualitative data.
4 of the 6 are based on Paul Tol's suggestions (see references) and are
meant to both optimize your ability to quickly differentiate the colors
and to be distinguishable to colorblind people.
These are called
\code{"Qual1"}, \code{"Qual2"}, \code{"Qual3"}, \code{"CUD"}, \code{"CUD Bright"}, and \code{"Rainbow"}.
Each of the "Qual" schemes comes from Paul Tol.
"Rainbow" is Paul Tol's compromise rainbow color scheme that is fairly
differentiable for colorblind people and when rendered in grayscale.
\code{"CUD Bright"} is a brightened and reordered version of Okabe and Ito's
suggestions for 'Color Universal Design' while \code{"CUD"} is their exact
scheme (see references). \code{"CUD Bright"} is the default for qualitative
scales in \code{jtools} functions.

You may also provide any color palette supported by \code{RColorBrewer}.
See all of those options at \code{\link[RColorBrewer:brewer.pal]{RColorBrewer::brewer.pal()}}'s documentation.
If you provide one of \code{RColorBrewer}'s sequential palettes, like "Blues",
\code{jtools} automatically requests one more color than needed from
\code{brewer.pal} and then drops the lightest color. My experience is that
those scales tend to give one color that is too light to easily
differentiate against a white background.

Lastly, you may provide colors by name. This must be a vector of the
same length as whatever it is the colors will correspond to (e.g.,
3 colors for 3 values of the moderator in \code{interact_plot}). The format
must be one understood by \code{ggplot2}'s manual scale functions. This
basically means it needs to be in hex format (e.g., "#000000") or
one of the many names R understands (e.g., "red"; use \code{colors()} to
see all of those options).
}
\references{
Paul Tol's site is what is used to derive 4 of the 6 \code{jtools}-specific
palettes: \url{https://personal.sron.nl/~pault/}

Okabe and Ito's palette inspired "CUD Bright", though "CUD Bright" is not
exactly the same. "CUD" is the same.
See \url{http://jfly.iam.u-tokyo.ac.jp/color/} for more.
}
