% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_new_data.R
\name{get_formula}
\alias{get_formula}
\alias{get_formula.default}
\alias{get_formula.brmsfit}
\alias{get_formula.panelmodel}
\title{Retrieve formulas from model objects}
\usage{
get_formula(model, ...)

\method{get_formula}{default}(model, ...)

\method{get_formula}{brmsfit}(model, resp = NULL, dpar = NULL, ...)

\method{get_formula}{panelmodel}(model, ...)
}
\arguments{
\item{model}{The fitted model object.}

\item{...}{Ignored.}

\item{resp}{For \code{brmsfit} objects, the response variable for which
the formula is desired. \code{brmsfit} objects may have multiple formulas, so
this selects a particular one. If \code{NULL}, the first formula is chosen
(unless \code{dpar} is specified).}

\item{dpar}{For \code{brmsfit} objects, the distributional variable for which
the formula is desired. If \code{NULL}, no distributional parameter is used.
If there are multiple responses with distributional parameters, then
\code{resp} should be specified or else the first formula will be used by
default.}
}
\value{
A \code{formula} object.
}
\description{
This function is primarily an internal helper function in \code{jtools} and
related packages to standardize the different types of formula objects used
by different types of models.
}
\examples{

data(mtcars)
fit <- lm(mpg ~ cyl, data = mtcars)
get_formula(fit)

}
