% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcsformats.R
\name{format_xx_fct}
\alias{format_xx_fct}
\title{Function factory for xx style formatting}
\usage{
format_xx_fct(
  roundmethod = c("sas", "iec"),
  na_str_dflt = "NE",
  replace_na_dflt = TRUE
)
}
\arguments{
\item{roundmethod}{(\code{string})\cr choice of rounding methods. Options are:
\itemize{
\item \code{sas}: the underlying rounding method is \code{tidytlg::roundSAS}, where \cr
roundSAS comes from this Stack Overflow post https://stackoverflow.com/questions/12688717/round-up-from-5
\item \code{iec}: the underlying rounding method is \code{round}
}}

\item{na_str_dflt}{Character to represent NA value}

\item{replace_na_dflt}{logical(1). Should an \code{na_string} of "NA" within
the formatters framework be overridden by \code{na_str_default}? Defaults to
\code{TRUE}, as a way to have a different default na string behavior from the
base \code{formatters} framework.}
}
\value{
\code{format_xx_fct()} format function that can be used in rtables formatting calls
}
\description{
A function factory to generate formatting functions for value
formatting that support the xx style format and control the rounding method
}
\examples{
jjcsformat_xx_SAS <- format_xx_fct(roundmethod = "sas")
jjcsformat_xx <- jjcsformat_xx_SAS
rcell(c(1.453), jjcsformat_xx("xx.xx"))
rcell(c(), jjcsformat_xx("xx.xx"))
rcell(c(1.453, 2.45638), jjcsformat_xx("xx.xx (xx.xxx)"))

}
\seealso{
Other JJCS formats: 
\code{\link{count_fraction}},
\code{\link{jjcsformat_pval_fct}()},
\code{\link{jjcsformat_range_fct}()}
}
\concept{JJCS formats}
