% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_justifications.R,
%   R/load_justifications_dir.R
\name{load_justifications}
\alias{load_justifications}
\alias{load_justifications_dir}
\alias{print.justifications}
\alias{plot.justifications}
\title{Load Justifications from a file or multiple files}
\usage{
load_justifications(text, file, delimiterRegEx = "^---$",
  justificationContainer = c("justifier", "justification", "decision",
  "assertion", "source"), ignoreOddDelimiters = FALSE,
  encoding = "UTF-8", silent = TRUE)

load_justifications_dir(path, recursive = TRUE, extension = "jmd",
  regex, justificationContainer = c("justifier", "justification",
  "decision", "assertion", "source"), delimiterRegEx = "^---$",
  ignoreOddDelimiters = FALSE, encoding = "UTF-8", silent = TRUE)
}
\arguments{
\item{text, file}{As \code{text} or \code{file}, you can specify a \code{file} to read with
encoding \code{encoding}, which will then be read using \code{\link[base:readLines]{base::readLines()}}. If the
argument is named \code{text}, whether it is the path to an existing file is checked
first, and if it is, that file is read. If the argument is named \code{file}, and it
does not point to an existing file, an error is produced (useful if calling
from other functions). A \code{text} should be a character vector where every
element is a line of the original source (like provided by \code{\link[base:readLines]{base::readLines()}});
although if a character vector of one element \emph{and} including at least one
newline character (\code{\\n}) is provided as \code{text}, it is split at the newline
characters using \code{\link[base:strsplit]{base::strsplit()}}. Basically, this behavior means that the
first argument can be either a character vector or the path to a file; and if
you're specifying a file and you want to be certain that an error is thrown if
it doesn't exist, make sure to name it \code{file}.}

\item{delimiterRegEx}{The regular expression used to locate YAML
fragments}

\item{justificationContainer}{The container of the justifications in the YAML
fragments. Because only justifications are read that are stored in
this container, the files can contain YAML fragments with other data, too,
without interfering with the parsing of the justifications.}

\item{ignoreOddDelimiters}{Whether to throw an error (FALSE) or
delete the last delimiter (TRUE) if an odd number of delimiters is
encountered.}

\item{encoding}{The encoding to use when calling \code{\link[=readLines]{readLines()}}. Set to
NULL to let \code{\link[=readLines]{readLines()}} guess.}

\item{silent}{Whether to be silent (TRUE) or informative (FALSE).}

\item{path}{The path containing the files to read.}

\item{recursive}{Whether to also process subdirectories (\code{TRUE})
or not (\code{FALSE}).}

\item{extension}{The extension of the files to read; files with other extensions will
be ignored. Multiple extensions can be separated by a pipe (\code{|}).}

\item{regex}{Instead of specifing an extension, it's also possible to specify a regular
expression; only files matching this regular expression are read. If specified, \code{regex}
takes precedece over \code{extension},}
}
\value{
An object with the \link[ggplot2:ggplot]{ggplot2::ggplot} graph stored
in \code{output$graph} and the overview in \code{output$overview}.
}
\description{
These function load justifications from the YAML fragments
in one (\code{load_justifications}) or multiple files (\code{load_justifications_dir}).
}
\details{
\code{load_justifications_dir} simply identifies all files and then calls
\code{load_justifications} for each of them. \code{load_justifications} loads the
YAML fragments containing the justifications using
\code{\link[yum:load_yaml_fragments]{yum::load_yaml_fragments()}} and then parses the justifications
into a visual representation as a
\link[ggplot2:ggplot]{ggplot2::ggplot} graph and Markdown documents with
overviews.
}
\examples{
exampleMinutes <- 'This is an example of minutes that include
a source, an assertion, and a justification. For example, in
the meeting, we can discuss the assertion that sleep deprivation
affects decision making. We could quickly enter this assertion in
a machine-readable way in this manner:

---
assertion:
  -
    id: assertion_SD_decision
    label: Sleep deprivation affects the decision making proces.
    source:
      id: source_Harrison
---

Because it is important to refer to sources, we cite a source as well.
We have maybe specified that source elsewhere, for example in the
minutes of our last meeting. That specification may have looked
like this:

---
source:
  -
    id: source_Harrison
    label: "Harrison & Horne (2000) The impact of sleep deprivation on decision making: A review."
    xdoi: "doi:10.1037/1076-898x.6.3.236"
    type: "Journal article"
---

We can now refer to these two specifications later on, for
example to justify decisions we take.
';

load_justifications(text=exampleMinutes);

### To load a directory with justifications
examplePath <-
  file.path(system.file(package="justifier"),
            'extdata');
load_justifications_dir(path=examplePath);

}
