% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{as_numeric_nowarn}
\alias{as_numeric_nowarn}
\alias{asIntegerNoWarn}
\alias{as_integer_nowarn}
\alias{is_integerish}
\alias{areIntegers}
\title{convert factor or vector to numeric without warnings}
\usage{
as_numeric_nowarn(x)

as_integer_nowarn(x)

is_integerish(x, tol = 1e-09, na.ignore = FALSE)

areIntegers(x, tol = 1e-09, na.ignore = FALSE)
}
\arguments{
\item{x}{is a vector, probably of numbers of characters}

\item{tol}{tolerance when considering if two numbers are integers, default
1e-9}

\item{na.ignore}{logical, if TRUE will pass through NA values, otherwise,
they are marked FALSE.}
}
\value{
numeric vector, may have NA values

logical vector
}
\description{
correctly converts factors to vectors, and then converts to
  numeric or integer, which may silently introduce NAs. Invisible rounding
  errors can be a problem going from numeric to integer, so consider adding
  tolerance to this conversion. \code{asIntegerNoWarn} silently
  \code{\link{floor}}s.
}
\details{
"are" functions return a value for each input, where is "allIs" functions
  return a single logical.
}
\section{Functions}{
\itemize{
\item \code{areIntegers}: Deprecated
}}

\examples{
stopifnot(is_integerish("1"))
}
