% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.r
\name{zero_na}
\alias{zero_na}
\title{Zero NA values in a data.frame}
\usage{
zero_na(x, cols = names(x), ignore = character(), verbose = FALSE,
  na_ish = TRUE, new_val = 0)
}
\arguments{
\item{x}{data.frame}

\item{cols}{names of columns to work on, default is all columns}

\item{ignore}{character vector of columns names to ignore}

\item{verbose}{TRUE or FALSE}

\item{na_ish}{Logical, default `TRUE` which will convert NA-like strings, too}

\item{new_val}{`0`}
}
\description{
Zero NA values in a data.frame, including \code{cols} and exluding
\code{ignore}. Also does not replace \code{Date} or \code{POSIXt} fields.
}
\examples{
d <- data.frame(1:5, 6:10, 11:15)
d[2, 3] <- NA
d[5, 2] <- NA
d[1, 1] <- NA
print(d)
zero_na(d)
d[1, 1] <- "NA"
zero_na(d, na_ish = TRUE)
}
