% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mcd.R
\docType{methods}
\name{mcd}
\alias{mcd}
\alias{mcd-method}
\alias{mcd,numeric,numeric-method}
\alias{mcd,CountMatrix,numeric-method}
\alias{bootstrap,MeanDate-method}
\alias{jackknife,MeanDate-method}
\title{Mean Ceramic Date}
\usage{
mcd(object, dates, ...)

\S4method{mcd}{numeric,numeric}(object, dates, na.rm = FALSE)

\S4method{mcd}{CountMatrix,numeric}(object, dates)

\S4method{bootstrap}{MeanDate}(
  object,
  level = 0.95,
  type = c("student", "normal"),
  probs = c(0.25, 0.5, 0.75),
  n = 1000
)

\S4method{jackknife}{MeanDate}(object)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector, a \link[arkhe:CountMatrix-class]{arkhe::CountMatrix} or a
\linkS4class{MeanDate} object.}

\item{dates}{A \code{\link{numeric}} vector of dates.}

\item{...}{Currently not used.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values (including \code{NaN}) be
removed?}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Must be a single number between \eqn{0} and \eqn{1}. If \code{NULL}, no
confidence interval are computed.}

\item{type}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{student}" (default) or
"\code{normal}". Any unambiguous substring can be given. Only used if \code{level}
is not \code{NULL}.``}

\item{probs}{A \code{\link{numeric}} vector of probabilities with values in
\eqn{[0,1]} (see \code{\link[stats:quantile]{stats::quantile()}}). If \code{NULL}, quantiles are not
computed.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
\itemize{
\item \code{mcd()} returns a single \code{\link{numeric}} value or a \linkS4class{MeanDate} object.
\item \code{bootstrap()} and \code{jackknife()} return a \code{\link{data.frame}}.
}
}
\description{
Estimates the Mean Ceramic Date of an assemblage.
}
\details{
The Mean Ceramic Date (MCD) is a point estimate of the occupation of an
archaeological site (South 1977). The MCD is estimated as the weighted mean
of the date midpoints of the ceramic types (based on absolute dates or the
known production interval) found in a given assemblage. The weights are the
relative frequencies of the respective types in the assemblage.

A bootstrapping procedure is used to estimate the confidence interval of a
given MCD. For each assemblage, a large number of new bootstrap replicates
is created, with the same sample size, by resampling the original
assemblage with replacement. MCDs are calculated for each replicates and
upper and lower boundaries of the confidence interval associated with each
MCD are then returned.
}
\examples{
## Mean Ceramic Date
## Coerce the zuni dataset to an abundance (count) matrix
data("zuni", package = "folio")
counts <- as_count(zuni)

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Calculate date midpoints
mid <- vapply(X = dates, FUN = mean, FUN.VALUE = numeric(1))

## Calculate MCD
mc_dates <- mcd(counts, dates = mid)
head(mc_dates)

## Plot
plot(mc_dates, select = 100:125)

## Bootstrap resampling
boot <- bootstrap(mc_dates, n = 30)
head(boot)

## Jackknife resampling
jack <- jackknife(mc_dates)
head(jack)
}
\references{
South, S. A. (1977). \emph{Method and Theory in Historical Archaeology}.
New York: Academic Press.
}
\seealso{
\link[=plot]{plot_mcd}

Other dating methods: 
\code{\link{event}()}
}
\author{
N. Frerebeau
}
\concept{dating methods}
