% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mcd.R
\docType{methods}
\name{resample_mcd}
\alias{resample_mcd}
\alias{bootstrap,MeanDate-method}
\alias{jackknife,MeanDate-method}
\alias{simulate,MeanDate-method}
\title{Resample Mean Ceramic Dates}
\usage{
\S4method{bootstrap}{MeanDate}(object, n = 1000, f = NULL, calendar = getOption("kairos.calendar"))

\S4method{jackknife}{MeanDate}(object, f = NULL, calendar = getOption("kairos.calendar"))

\S4method{simulate}{MeanDate}(object, nsim = 1000)
}
\arguments{
\item{object}{A \code{\linkS4class{MeanDate}} object (typically returned by \code{\link[=mcd]{mcd()}}).}

\item{n}{A non-negative \code{\link{integer}} specifying the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
the resampling procedure) as argument.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[=calendar]{calendar()}}).}

\item{nsim}{A non-negative \code{\link{integer}} specifying the number of simulations.}
}
\value{
If \code{f} is \code{NULL}, \code{bootstrap()} and \code{jackknife()} return a \code{\link{data.frame}}
with the following elements (else, returns the result of \code{f} applied to the
\code{n} resampled values) :
\describe{
\item{original}{The observed value.}
\item{mean}{The bootstrap/jackknife estimate of mean.}
\item{bias}{The bootstrap/jackknife estimate of bias.}
\item{error}{The boostrap/jackknife estimate of standard erro.}
}
}
\description{
\itemize{
\item \code{bootstrap()} generate bootstrap estimations of an \link[=mcd]{MCD}.
\item \code{jackknife()} generate jackknife estimations of an \link[=mcd]{MCD}.
}
}
\seealso{
Other mean ceramic date tools: 
\code{\link{mcd}()},
\code{\link{plot_mcd}}
}
\author{
N. Frerebeau
}
\concept{mean ceramic date tools}
