% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanjistat-package.R
\docType{data}
\encoding{UTF-8}
\name{fivetrees}
\alias{fivetrees}
\alias{fivetrees1}
\alias{fivetrees2}
\alias{fivetrees3}
\title{Sample lists of kanjimat objects}
\format{
\code{fivetrees1}, \code{fivetrees2} and \code{fivetrees3} are lists of five \code{\link{kanjimat}}
objects each, representing the same five basic kanji \\u6821,\\u6728,\\u4f11,\\u6797,\\u76f8, containing each
a tree component. Their matrices are antialiased 64 x 64 pixel representations of the kanji. The size
is chosen as a compromise between aesthetics and memory/computational cost,
such as for \code{\link{kmatdist}}.

All of them are in handwriting style fonts.
\code{fivetrees1} is in a Kyoukasho font (schoolbook style),
\code{fivetrees2} is in a Kaisho font (regular script calligraphy font)
\code{fivetrees3} is in a Gyousho font (semi-cursive calligraphy font)

An object of class \code{list} of length 5.

An object of class \code{list} of length 5.

An object of class \code{list} of length 5.
}
\source{
The list has been generated with the function \code{\link{kanjimat}} using the Mac OS
pre-installed YuKyokasho font (fivetrees1), as well as the freely available fonts nagayama_kai
by Norio Nagayama and KouzanBrushFontGyousyo by Aoyagi Kouzan.
}
\usage{
fivetrees1

fivetrees2

fivetrees3
}
\description{
Sample lists of kanjimat objects
}
\examples{
oldpar <- par(mfrow = c(3,5))
invisible( lapply(fivetrees1, plot) )
invisible( lapply(fivetrees2, plot) )
invisible( lapply(fivetrees3, plot) )
par(oldpar)
  
}
\keyword{datasets}
