% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-dropout.R
\name{layer_spatial_dropout_1d}
\alias{layer_spatial_dropout_1d}
\title{Spatial 1D version of Dropout.}
\usage{
layer_spatial_dropout_1d(
  object,
  rate,
  batch_size = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{rate}{float between 0 and 1. Fraction of the input units to drop.}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
This version performs the same function as Dropout, however it drops entire
1D feature maps instead of individual elements. If adjacent frames within
feature maps are strongly correlated (as is normally the case in early
convolution layers) then regular dropout will not regularize the activations
and will otherwise just result in an effective learning rate decrease. In
this case, \code{layer_spatial_dropout_1d} will help promote independence between
feature maps and should be used instead.
}
\section{Input shape}{
 3D tensor with shape: \verb{(samples, timesteps, channels)}
}

\section{Output shape}{
 Same as input
}

\section{References}{
 - \href{https://arxiv.org/abs/1411.4280}{Efficient Object Localization Using Convolutional Networks}
}

\seealso{
Other dropout layers: 
\code{\link{layer_dropout}()},
\code{\link{layer_spatial_dropout_2d}()},
\code{\link{layer_spatial_dropout_3d}()}
}
\concept{dropout layers}
