% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_gamma}
\alias{random_gamma}
\title{Draw random samples from the Gamma distribution.}
\usage{
random_gamma(shape, alpha, dtype = NULL, seed = NULL)
}
\arguments{
\item{shape}{The shape of the random values to generate.}

\item{alpha}{Float, the parameter of the distribution.}

\item{dtype}{Optional dtype of the tensor. Only floating point types are
supported. If not specified, \code{\link[=config_floatx]{config_floatx()}} is used,
which defaults to \code{float32} unless you configured it otherwise (via
\code{config_set_floatx(float_dtype)}).}

\item{seed}{An R integer or instance of
\code{\link[=random_seed_generator]{random_seed_generator()}}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or \code{NULL} (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{\link[=random_seed_generator]{random_seed_generator()}}.}
}
\value{
A tensor of random values.
}
\description{
Draw random samples from the Gamma distribution.
}
\seealso{
Other random: \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
