% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-rnn.R
\name{layer_conv_lstm_1d}
\alias{layer_conv_lstm_1d}
\title{1D Convolutional LSTM.}
\usage{
layer_conv_lstm_1d(
  object,
  filters,
  kernel_size,
  strides = 1L,
  padding = "valid",
  data_format = NULL,
  dilation_rate = 1L,
  activation = "tanh",
  recurrent_activation = "sigmoid",
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  unit_forget_bias = TRUE,
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  seed = NULL,
  return_sequences = FALSE,
  return_state = FALSE,
  go_backwards = FALSE,
  stateful = FALSE,
  ...,
  unroll = NULL
)
}
\arguments{
\item{object}{Object to compose the layer with. A tensor, array, or sequential model.}

\item{filters}{int, the dimension of the output space (the number of filters
in the convolution).}

\item{kernel_size}{int or tuple/list of 1 integer, specifying the size of
the convolution window.}

\item{strides}{int or tuple/list of 1 integer, specifying the stride length
of the convolution. \code{strides > 1} is incompatible with
\code{dilation_rate > 1}.}

\item{padding}{string, \code{"valid"} or \code{"same"} (case-insensitive).
\code{"valid"} means no padding. \code{"same"} results in padding evenly to
the left/right or up/down of the input such that output has the
same height/width dimension as the input.}

\item{data_format}{string, either \code{"channels_last"} or \code{"channels_first"}.
The ordering of the dimensions in the inputs. \code{"channels_last"}
corresponds to inputs with shape \verb{(batch, steps, features)}
while \code{"channels_first"} corresponds to inputs with shape
\verb{(batch, features, steps)}. It defaults to the \code{image_data_format}
value found in your Keras config file at \verb{~/.keras/keras.json}.
If you never set it, then it will be \code{"channels_last"}.}

\item{dilation_rate}{int or tuple/list of 1 integers, specifying the dilation
rate to use for dilated convolution.}

\item{activation}{Activation function to use. By default hyperbolic tangent
activation function is applied (\code{tanh(x)}).}

\item{recurrent_activation}{Activation function to use for the recurrent step.}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix,
used for the linear transformation of the inputs.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel} weights
matrix, used for the linear transformation of the recurrent state.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{unit_forget_bias}{Boolean. If \code{TRUE}, add 1 to the bias of
the forget gate at initialization.
Use in combination with \code{bias_initializer="zeros"}.
This is recommended in \href{https://proceedings.mlr.press/v37/jozefowicz15.pdf}{Jozefowicz et al., 2015}}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel} weights
matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to.}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{recurrent_constraint}{Constraint function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
linear transformation of the inputs.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop
for the linear transformation of the recurrent state.}

\item{seed}{Random seed for dropout.}

\item{return_sequences}{Boolean. Whether to return the last output
in the output sequence, or the full sequence. Default: \code{FALSE}.}

\item{return_state}{Boolean. Whether to return the last state in addition
to the output. Default: \code{FALSE}.}

\item{go_backwards}{Boolean (default: \code{FALSE}).
If \code{TRUE}, process the input sequence backwards and return the
reversed sequence.}

\item{stateful}{Boolean (default \code{FALSE}). If \code{TRUE}, the last state
for each sample at index i in a batch will be used as initial
state for the sample of index i in the following batch.}

\item{...}{For forward/backward compatability.}

\item{unroll}{Boolean (default: \code{FALSE}).
If \code{TRUE}, the network will be unrolled,
else a symbolic loop will be used.
Unrolling can speed-up a RNN,
although it tends to be more memory-intensive.
Unrolling is only suitable for short sequences.}
}
\value{
The return value depends on the value provided for the first argument.
If  \code{object} is:
\itemize{
\item a \code{keras_model_sequential()}, then the layer is added to the sequential model
(which is modified in place). To enable piping, the sequential model is also
returned, invisibly.
\item a \code{keras_input()}, then the output tensor from calling \code{layer(input)} is returned.
\item \code{NULL} or missing, then a \code{Layer} instance is returned.
}
}
\description{
Similar to an LSTM layer, but the input transformations
and recurrent transformations are both convolutional.
}
\section{Call Arguments}{
\itemize{
\item \code{inputs}: A 4D tensor.
\item \code{initial_state}: List of initial state tensors to be passed to the first
call of the cell.
\item \code{mask}: Binary tensor of shape \verb{(samples, timesteps)} indicating whether a
given timestep should be masked.
\item \code{training}: Python boolean indicating whether the layer should behave in
training mode or in inference mode.
This is only relevant if \code{dropout} or \code{recurrent_dropout} are set.
}
}

\section{Input Shape}{
\itemize{
\item If \code{data_format="channels_first"}:
4D tensor with shape: \verb{(samples, time, channels, rows)}
\item If \code{data_format="channels_last"}:
4D tensor with shape: \verb{(samples, time, rows, channels)}
}
}

\section{Output Shape}{
\itemize{
\item If \code{return_state}: a list of tensors. The first tensor is the output.
The remaining tensors are the last states,
each 3D tensor with shape: \verb{(samples, filters, new_rows)} if
\code{data_format='channels_first'}
or shape: \verb{(samples, new_rows, filters)} if
\code{data_format='channels_last'}.
\code{rows} values might have changed due to padding.
\item If \code{return_sequences}: 4D tensor with shape: \verb{(samples, timesteps, filters, new_rows)} if data_format='channels_first'
or shape: \verb{(samples, timesteps, new_rows, filters)} if
\code{data_format='channels_last'}.
\item Else, 3D tensor with shape: \verb{(samples, filters, new_rows)} if
\code{data_format='channels_first'}
or shape: \verb{(samples, new_rows, filters)} if
\code{data_format='channels_last'}.
}
}

\section{References}{
\itemize{
\item \href{https://arxiv.org/abs/1506.04214v1}{Shi et al., 2015}
(the current implementation does not include the feedback loop on the
cells output).
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/recurrent_layers/conv_lstm1d#convlstm1d-class}
}

Other rnn layers: \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_batch_normalization}()} \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_flax_module_wrapper}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_group_query_attention}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_jax_model_wrapper}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_mel_spectrogram}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_multi_head_attention}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{layers}
\concept{rnn layers}
