% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraint_minmaxnorm}
\alias{constraint_minmaxnorm}
\title{MinMaxNorm weight constraint.}
\usage{
constraint_minmaxnorm(min_value = 0, max_value = 1, rate = 1, axis = 1L)
}
\arguments{
\item{min_value}{the minimum norm for the incoming weights.}

\item{max_value}{the maximum norm for the incoming weights.}

\item{rate}{rate for enforcing the constraint: weights will be
rescaled to yield
op_clip?
\code{(1 - rate) * norm + rate * op_clip(norm, min_value, max_value)}.
Effectively, this means that rate = 1.0 stands for strict
enforcement of the constraint, while rate<1.0 means that
weights will be rescaled at each step to slowly move
towards a value inside the desired interval.}

\item{axis}{integer, axis along which to calculate weight norms.
For instance, in a \code{Dense} layer the weight matrix
has shape \verb{(input_dim, output_dim)},
set \code{axis} to \code{0} to constrain each weight vector
of length \verb{(input_dim,)}.
In a \code{Conv2D} layer with \code{data_format = "channels_last"},
the weight tensor has shape
\verb{(rows, cols, input_depth, output_depth)},
set \code{axis} to \verb{[0, 1, 2]}
to constrain the weights of each filter tensor of size
\verb{(rows, cols, input_depth)}.}
}
\value{
A \code{Constraint} instance, a callable that can be passed to layer
constructors or used directly by calling it with tensors.
}
\description{
Constrains the weights incident to each hidden unit
to have the norm between a lower bound and an upper bound.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/constraints#minmaxnorm-class}
}

Other constraints: \cr
\code{\link{Constraint}()} \cr
\code{\link{constraint_maxnorm}()} \cr
\code{\link{constraint_nonneg}()} \cr
\code{\link{constraint_unitnorm}()} \cr
}
\concept{constraints}
