% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_leaky_relu}
\alias{activation_leaky_relu}
\title{Leaky relu activation function.}
\usage{
activation_leaky_relu(x, negative_slope = 0.2)
}
\arguments{
\item{x}{Input tensor.}

\item{negative_slope}{A \code{float} that controls the slope
for values lower than the threshold.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
Leaky relu activation function.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/activations#leakyrelu-function}
}

Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
