% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{EarlyStopping}
\alias{EarlyStopping}
\title{Stop training when a monitored quantity has stopped improving.}
\usage{
EarlyStopping(monitor = "val_loss", min_delta = 0, patience = 0,
  verbose = 0, mode = "auto")
}
\arguments{
\item{monitor}{quantity to be monitored.}

\item{min_delta}{minimum change in the monitored quantity to qualify
as an improvement, i.e. an absolute change of less than
min_delta, will count as no improvement.}

\item{patience}{number of epochs with no improvement after which
training will be stopped.}

\item{verbose}{verbosity mode.}

\item{mode}{one of {auto, min, max}. In min mode, training will
stop when the quantity monitored has stopped
decreasing; in max mode it will stop when the
quantity monitored has stopped increasing; in
auto mode, the direction is automatically inferred
from the name of the monitored quantity.}
}
\description{
Stop training when a monitored quantity has stopped improving.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  callbacks <- list(CSVLogger(tempfile()),
                    EarlyStopping(),
                    ReduceLROnPlateau(),
                    TensorBoard(tempfile()))

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, callbacks = callbacks, validation_split = 0.2)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other callbacks: \code{\link{CSVLogger}},
  \code{\link{ModelCheckpoint}},
  \code{\link{ReduceLROnPlateau}},
  \code{\link{TensorBoard}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
