% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{ReduceLROnPlateau}
\alias{ReduceLROnPlateau}
\title{Reduce learning rate when a metric has stopped improving.}
\usage{
ReduceLROnPlateau(monitor = "val_loss", factor = 0.1, patience = 10,
  verbose = 0, mode = "auto", epsilon = 1e-04, cooldown = 0,
  min_lr = 0)
}
\arguments{
\item{monitor}{quantity to be monitored.}

\item{factor}{factor by which the learning rate will be reduced.
new_lr = lr * factor}

\item{patience}{number of epochs with no improvement after which
learning rate will be reduced.}

\item{verbose}{int. 0: quiet, 1: update messages.}

\item{mode}{one of {auto, min, max}. In min mode, lr will be
reduced when the quantity monitored has stopped
decreasing; in max mode it will be reduced when
the quantity monitored has stopped increasing;
in auto mode, the direction is automatically
inferred from the name of the monitored quantity.}

\item{epsilon}{threshold for measuring the new optimum, to only
focus on significant changes.}

\item{cooldown}{number of epochs to wait before resuming normal
operation after lr has been reduced.}

\item{min_lr}{lower bound on the learning rate.}
}
\description{
Models often benefit from reducing the learning rate by a factor of
2-10 once learning stagnates. This callback monitors a quantity and
if no improvement is seen for a 'patience' number of epochs, the
learning rate is reduced.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  callbacks <- list(CSVLogger(tempfile()),
                    EarlyStopping(),
                    ReduceLROnPlateau(),
                    TensorBoard(tempfile()))

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, callbacks = callbacks, validation_split = 0.2)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other callbacks: \code{\link{CSVLogger}},
  \code{\link{EarlyStopping}},
  \code{\link{ModelCheckpoint}}, \code{\link{TensorBoard}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
