% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{keras_fit}
\alias{keras_fit}
\title{Fit a keras model}
\usage{
keras_fit(model, x, y, batch_size = 32, epochs = 10, verbose = 1,
  callbacks = NULL, validation_split = 0, validation_data = NULL,
  shuffle = TRUE, class_weight = NULL, sample_weight = NULL,
  initial_epoch = 0)
}
\arguments{
\item{model}{a keras model object, for example created with \code{\link[=Sequential]{Sequential()}}}

\item{x}{numeric matrix of input data}

\item{y}{a numeric matrix or numeric vector containing labels.}

\item{batch_size}{integer. Number of samples per gradient update.}

\item{epochs}{integer, the number of epochs to train the model.}

\item{verbose}{0 for no logging to stdout, 1 for progress bar
logging, 2 for one log line per epoch.}

\item{callbacks}{list of callbacks to apply during training.
See \code{\link[=EarlyStopping]{EarlyStopping()}} or \code{\link[=TensorBoard]{TensorBoard()}} for examples.}

\item{validation_split}{numeric (\code{0 < x < 1}). Fraction of the data to
use as held-out validation data.}

\item{validation_data}{\code{list(x_val, y_val)} or \code{list(x_val, y_val, val_sample_weights)} to be used as held-out
validation data. Will override
\code{validation_split}.}

\item{shuffle}{boolean or string (for \code{batch}). Whether to
shuffle the samples at each epoch. \code{batch} is
a special option for dealing with the
limitations of HDF5 data; it shuffles
in batch-sized chunks.}

\item{class_weight}{dictionary mapping classes to a weight value,
used for scaling the loss function (during
training only).}

\item{sample_weight}{numeric array of weights for the training samples}

\item{initial_epoch}{epoch at which to start training}
}
\description{
Learn the weight and bias values for am model given training data.
Model must be compiled first. The model is modified in place.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(  Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  # You can also add layers directly as arguments to Sequential()

  mod <- Sequential(
    Dense(units = 50, input_shape = ncol(X_train)),
    Dropout(rate = 0.5),
    Activation("relu"),
    Dense(units = 3),
    ActivityRegularization(l1 = 1),
    Activation("softmax")
  )
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
}

}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
\code{\link[=keras_compile]{keras_compile()}}

Other model functions: \code{\link{LoadSave}},
  \code{\link{Predict}}, \code{\link{Sequential}},
  \code{\link{keras_compile}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
