% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_SCR_data.R
\name{sim_SCR_data}
\alias{sim_SCR_data}
\title{Data Simulation Function}
\usage{
sim_SCR_data(data_size, ncol_gene_mat, feat_m, feat_d, mu_cen, cov,
  lam_m = 1/15, lam_d = 1/20, norm_vcov = c(1, 0.5, 0.5, 1))
}
\arguments{
\item{data_size}{an integer giving the simulated sample size \code{N}}

\item{ncol_gene_mat}{an integer giving the simulated number of genomic covariates \code{P}}

\item{feat_m}{a function that transforms the genomic features into the signal for the metastasis
process. This function should a matrix of dimensions \code{N X P} as its only argument.}

\item{feat_d}{a function that transforms the genomic features into the signal for the death
process. This function should a matrix of dimensions \code{N X P} as its only argument.}

\item{mu_cen}{mean of the exponential censoring process}

\item{cov}{the correlation between the genomic covariates}

\item{lam_m}{baseline hazard constant for metastasis process. Default is \code{1/15}.}

\item{lam_d}{baseline hazard constant for death process. Default is \code{1/20}.}

\item{norm_vcov}{vector of length 4 of correlation between errors between the two processes on
the normal scale before being complementary-log-log-transformed. Default is \code{c(1,.5,.5,1)}.}
}
\value{
a \code{data.frame} with columns:\itemize{
\item{\code{XR}:}{ time to recurrence / death / censoring}
\item{\code{XD}:}{ time to death / censoring}
\item{\code{DeltaR}:}{ Indicator of censoring (0), recurrence (1), or death (2) for this earliest time XR}
\item{\code{DeltaD}:}{ Indicator of censoring (0) or death (1)}
\item{\code{XPFS}:}{ time to recurrence / death / censoring (=XR)}
\item{\code{DeltaPFS}:}{ Indicator of censoring (0) or recurrence or death, whichever came first (1)}
\item{\code{Z_1,...,Z_P}:}{ genomic variables}
}
}
\description{
Data Simulation Function
}
\examples{
feat_m_fun <- function(X){
 sin(X[,1]+X[,2]^2)-1
}
feat_d_fun <-  function(X){
 (X[,4]-X[,5])^2/8
}
mydata <- sim_SCR_data(data_size = 400, ncol_gene_mat = 20, feat_m = feat_m_fun,
                      feat_d = feat_d_fun, mu_cen = 30, cov=0.5)
head(mydata)
## how many experience both events
mean(mydata[,"DeltaR"]==1 & mydata[,"DeltaD"]==1)
## how many only recur
mean(mydata[,"DeltaR"]==1 & mydata[,"DeltaD"]==0)
## how many only die
mean(mydata[,"DeltaR"]==2 & mydata[,"DeltaD"]==1)
## how many are censored
mean(mydata[,"DeltaR"]==0 & mydata[,"DeltaD"]==0)


}

