% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.keyATM_output}
\alias{predict.keyATM_output}
\title{Predict topic proportions for the covariate keyATM}
\usage{
\method{predict}{keyATM_output}(
  object,
  newdata,
  transform = FALSE,
  burn_in = NULL,
  parallel = TRUE,
  mc.cores = NULL,
  posterior_mean = TRUE,
  ci = 0.9,
  method = c("hdi", "eti"),
  point = c("mean", "median"),
  label = NULL,
  raw_values = FALSE,
  ...
)
}
\arguments{
\item{object}{the keyATM_output object for the covariate model.}

\item{newdata}{New observations which should be predicted.}

\item{transform}{Transorm and standardize the \code{newdata} with the same formula and option as \code{model_settings} used in \code{\link[=keyATM]{keyATM()}}.}

\item{burn_in}{integer. Burn-in period. If not specified, it is the half of samples. Default is \code{NULL}.}

\item{parallel}{logical. If \code{TRUE}, parallelization for speeding up. Default is \code{TRUE}.}

\item{mc.cores}{integer. The number of cores to use. Default is \code{NULL}.}

\item{posterior_mean}{logical. If \code{TRUE}, the quantity of interest to estimate is the posterior mean. Default is \code{TRUE}.}

\item{ci}{value of the credible interval (between 0 and 1) to be estimated. Default is \code{0.9} (90\%).}

\item{method}{method for computing the credible interval. The Highest Density Interval (\code{hdi}, default) or Equal-tailed Interval (\code{eti}).}

\item{point}{method for computing the point estimate. \code{mean} (default) or \code{median}.}

\item{label}{a character. Add a \code{label} column to the output. The default is \code{NULL} (do not add it).}

\item{raw_values}{a logical. Returns raw values. The default is \code{FALSE}.}

\item{...}{additional arguments not used.}
}
\description{
Predict topic proportions for the covariate keyATM
}
