% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{kpcent}
\alias{kpcent}
\title{Compute Group Centraltiy in a Network}
\usage{
kpcent(adj.matrix, nodes, type, M = Inf, T = ncol(adj.matrix), method,
  binary = FALSE, cmode)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If there are multiple players,
use \code{c(index1,index2,...)}}

\item{type}{\code{type="betweenness"} for \code{\link[sna]{betweenness}} centrality. \cr
\code{type="closeness"} for \code{\link[sna]{closeness}} centrality. \cr
\code{type="degree"} for \code{\link[sna]{degree}} centraslity. \cr
\code{type="diffusion"} for \code{\link{diffusion}} centrality. \cr
\code{type="evcent"} for \code{\link[sna]{evcent}} (eigenvector) centrality. \cr
\code{type="fragment"} for \code{\link{fragment}} centrality. \cr
\code{type="mreach.degree"} for \code{\link{mreach.degree}} centrality. \cr
\code{type="mreach.closeness"} for \code{\link{mreach.closeness}} centrality. \cr}

\item{M}{Positive number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected. The default is
\code{Inf}. The option is applicable to mreach.degree, mreach.closeness,
and fragmentation centralities.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. For diffusion centrality only.
In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}

\item{method}{Indication of which grouping criterion should be used. \cr
\code{"min"} indicates the "minimum" criterion and is the default for
betweenness, closeness, fragmentation, and M-reach centralities. \cr
\code{"max"} indicates the "maximum" criterion and is the default for
degree and eigenvector centralities.\cr
\code{"add"} indicates the "addition" criterion.\cr
\code{"union"} indicates the "union" criterion and is the default for
diffusion centrality.\cr
See Details section for explanations on grouping method.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. By default, \code{binary=FALSE}}

\item{cmode}{String indicating the type of centrality being evaluated.
The option is applicable to degree and M-reach centralities.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and (total) degree respectively. \code{"all"} reports
all the above measures. The default is to report the total degree.
The option also applies to closeness centrality, but with different options.
The default is to use the Gil-Schmidt power index as the closeness measure.
See \code{\link[sna]{closeness}} for complete options.}
}
\value{
A vector indicating the centrality score or a data frame containing
the summery information of the directed centrality scores.
}
\description{
\code{kpcent} reports the group-level centrality scores of the specified
type of centrality measure.
}
\details{
The basic idea of measuring the group-level centrality is to treat
a group of nodes as a large pseudo-node. We propose several methods to measure
the tie status between this pseudo node and other nodes, responding to several
common edge value interpretations (An and Liu, 2015).

Minimum Criterion: the edge value between a group and an outside node
is measured as the minimal value among all the (nonzero) edge values between
any node in the group and the outside node. Suggested if edge values are
interpreted as distances.\cr
\emph{Example: suppose node A to C has distance 2 and B to C has distance 1,
then according to the minimum criterion, the distance between C and
the merged set AB is 1. Note that if B and C are not connected,
the algorithm takes the distance between A and C to describe
the distance between AB and C.}

Maximun Criterion: the edge value between a group and an outside node
is measured as the maximal value among all the (nonzero) edge values between
any node in the group and the outside node. Suggested if edge values are
interpreted as non-cummulative strengths. \cr
\emph{Example: we keep using the above example, but the figure now indicates
the strength of tie. According to the maximum criterion, the strength of tie
between AB and C is 2.}

Addition Criterion: the edge value between a group and an outside node
is measured as the sum of all the edge values between any node in the group
and the outside node. Suggested if edge values are as cummulative strengths. \cr
\emph{Example: according to the addition criterion, the strength of tie between
AB and C is 3}

Union Criterion: the edge value between a group and an outside node is measured
as the probability that there is at least one path connecting the group with
the outside node. Suggested if edge values are as probability. \cr
\emph{Example: suppose A has probability 0.2 to reach C and B has probability
0.5 to reach C, then C can be reached from merged AB with probability
1-(1-0.2)*(1-0.5)=0.6 according to the union criterion.}
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix,
# where edge values represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# List the degree centrality for group of node 2 and 3
kpcent(W,c(2,3),type="degree")

# Transform the edge value to distance interpretaion
# Compute the fragmentation centrality for node 2
A <- W
A[W!=0] <- 1/W[W!=0]
kpcent(A,2,type="fragment")

# Replicate the group-level degree centrality (normalized) when the weights
# are given by the inverse distances and report the outgoing score only
kpcent(A,c(2,3),type="mreach.closeness",binary=TRUE,M=1,cmode="outdegree")

# Transform the edge value to probability interpretation
# Compute the diffusion centrality with number of iteration 20
P <- 0.1*W
kpcent(P,c(2,3),type="diffusion",T=20)
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
An, Weihua. (2015). "Multilevel Meta Network Analysis with Application to Studying Network Dynamics of Network Interventions." \emph{Social Networks} 43: 48-56.\cr

An, Weihua and Yu-Hsin Liu (2015). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{Working Paper}, Indiana Univeristy.\cr

Banerjee, A., A. Chandrasekhar, E. Duflo, and M. Jackson (2013):
"Diffusion of Microfinance," \emph{Science}, Vol. 341. p.363\cr

Banerjee, A., A. Chandrasekhar, E. Duflo, and M. Jackson (2014):
"Gossip: Identifying Central Individuals in a Social Network,"
Working paper\cr

Borgatti, Stephen P. (2006). "Identifying Sets of Key Players in a Network."
\emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr

Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{http://CRAN.R-project.org/package=sna}\cr
}
\seealso{
\code{\link{kpset}}
}

