% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-wincred.R
\docType{data}
\name{backend_wincred}
\alias{backend_wincred}
\title{Create a Windows Credential Store keyring backend}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
backend_wincred
}
\description{
This backend is the default on Windows. It uses the native Windows
Credential API, and needs at least Windows XP to run.
}
\details{
This backend supports multiple keyrings. Note that multiple keyrings
are implemented in the \code{keyring} R package, using some dummy keyring
keys that represent keyrings and their locked/unlocked state.

See \link{backend} for the documentation of the individual methods.
}
\examples{
\dontrun{
## This only works on Windows
kb <- backend_wincred$new()
kb$create_keyring("foobar")
kb$set_default_keyring("foobar")
kb$set_with_value("service", password = "secret")
kb$get("service")
kb$delete("service")
kb$delete_keyring("foobar")
}
}
\seealso{
Other keyring backends: \code{\link{backend_env}},
  \code{\link{backend_macos}},
  \code{\link{backend_secret_service}}
}
\keyword{datasets}
