% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fit-Functions.R
\name{agg_model_fit}
\alias{agg_model_fit}
\title{Summary table of model fit}
\usage{
agg_model_fit(kfits, index = "all", digits = 2)
}
\arguments{
\item{kfits}{an object returned from \code{\link[kfa]{k_model_fit}} when \code{by.folds = TRUE}}

\item{index}{character; one or more fit indices to summarize. Indices
must be present in the \code{kfits} object. Default is \code{"all"} indices present in \code{kfits}.
Chi-square value and degrees of freedom are always reported.}

\item{digits}{integer; number of decimal places to display in the report}
}
\value{
\code{data.frame} of aggregated model fit statistics
}
\description{
Summary table of model fit aggregated over k-folds
}
\examples{
data(example.kfa)
fits <- k_model_fit(example.kfa, by.fold = TRUE)
agg_model_fit(fits)

}
