% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_okabeito.R
\name{scale_okabeito_discrete}
\alias{scale_okabeito_discrete}
\alias{scale_colour_okabeito}
\alias{scale_color_okabeito}
\alias{scale_fill_okabeito}
\alias{scale_edge_colour_okabeito}
\alias{scale_edge_color_okabeito}
\alias{scale_edge_fill_okabeito}
\title{Okabe and Ito's Discrete Color Scheme for \pkg{ggplot2} and \pkg{ggraph}}
\usage{
scale_colour_okabeito(
  ...,
  reverse = FALSE,
  black_position = c("first", "last"),
  aesthetics = "colour"
)

scale_color_okabeito(
  ...,
  reverse = FALSE,
  black_position = c("first", "last"),
  aesthetics = "colour"
)

scale_fill_okabeito(
  ...,
  reverse = FALSE,
  black_position = c("first", "last"),
  aesthetics = "fill"
)

scale_edge_colour_okabeito(
  ...,
  reverse = FALSE,
  black_position = c("first", "last"),
  aesthetics = "edge_colour"
)

scale_edge_color_okabeito(
  ...,
  reverse = FALSE,
  black_position = c("first", "last"),
  aesthetics = "edge_colour"
)

scale_edge_fill_okabeito(
  ...,
  reverse = FALSE,
  black_position = c("first", "last"),
  aesthetics = "edge_fill"
)
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{black_position}{A \code{\link{character}} string giving the position of the black
color. It must be one of "\code{first}" or "\code{last}". Any unambiguous substring
can be given.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} scale.
}
\description{
Provides the qualitative color scale from Okabe and Ito 2008.
}
\details{
This qualitative color scheme is used as given (no interpolation):
colors are picked up to the maximum number of supported values (8).
}
\examples{
library(ggplot2)

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_okabeito()

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_okabeito(black_position = "last")
}
\references{
Okabe, M. & Ito, K. (2008). \emph{Color Universal Design (CUD): How to Make
Figures and Presentations That Are Friendly to Colorblind People}.
URL: \url{https://jfly.uni-koeln.de/color/}.
}
\seealso{
Other color-blind safe color schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_diverging}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_crameri_sequential}},
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}

Other qualitative color schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_soil}()},
\code{\link{scale_colour_stratigraphy}()},
\code{\link{scale_logical_discrete}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_discreterainbow}},
\code{\link{scale_tol_highcontrast}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_vibrant}}
}
\author{
N. Frerebeau
}
\concept{Okabe and Ito's color scheme}
\concept{color-blind safe color schemes}
\concept{qualitative color schemes}
