% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{palette_shape}
\alias{palette_shape}
\alias{palette_line}
\title{Symbol Mapping}
\usage{
palette_shape(symbols = NULL, domain = NULL, ordered = FALSE, ...)

palette_line(types = NULL, domain = NULL, ordered = FALSE, ...)
}
\arguments{
\item{symbols, types}{A vector of symbols or line types.}

\item{domain}{A vector of categorical data specifying the possible values
that can be mapped.}

\item{ordered}{A \code{\link{logical}} scalar: should the levels be treated as already
in the correct order?}

\item{...}{Currently not used.}
}
\value{
A palette \code{\link{function}} that when called with a single argument
(a \code{\link{character}} vector of categorical values) returns a vector of symbols.
}
\description{
Symbol Mapping
}
\examples{
## Build color palette functions
bright <- c(versicolor = "#4477AA", virginica = "#EE6677", setosa = "#228833")
pal_color <- palette_color_discrete(colors = bright)

## Build symbol palette functions
symbols <- c(versicolor = 15, virginica = 16, setosa = 17)
pal_shapes <- palette_shape(symbols)

## Plot
plot(
  x = iris$Petal.Length,
  y = iris$Sepal.Length,
  pch = pal_shapes(iris$Species),
  col = pal_color(iris$Species),
  xlab = "Petal length",
  ylab = "Sepal length",
  panel.first = grid(),
  las = 1
)
legend("topleft", legend = names(bright), col = bright, pch = symbols)
}
\seealso{
Other palettes: 
\code{\link{palette_color_continuous}()},
\code{\link{palette_color_discrete}()},
\code{\link{palette_color_picker}()},
\code{\link{palette_size_range}()}
}
\concept{palettes}
