% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_group_means.R
\name{plot_group_means}
\alias{plot_group_means}
\title{Plot group means}
\usage{
plot_group_means(
  data = NULL,
  dv_name = NULL,
  iv_name = NULL,
  error_bar = "ci",
  error_bar_range = 0.95,
  line_size = 1,
  dot_size = 3,
  error_bar_tip_width = 0.13,
  position_dodge = 0.13,
  legend_position = "right"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable}

\item{iv_name}{name(s) of the independent variable(s).
Up to two independent variables can be supplied.}

\item{error_bar}{if \code{error_bar = "se"}; error bars will be +/-1
standard error, if \code{error_bar = "ci"} error bars will be a
confidence interval; if \code{error_bar = "pi"}, error bars will be
a prediction interval}

\item{error_bar_range}{width of the confidence or prediction interval
(default = 0.95 for 95 percent confidence or prediction interval).
This argument will not apply when \code{error_bar = "se"}}

\item{line_size}{thickness of the lines connecting group means,
(default = 1)}

\item{dot_size}{size of the dots indicating group means (default = 3)}

\item{error_bar_tip_width}{graphically, width of the segments
at the end of error bars (default = 0.13)}

\item{position_dodge}{by how much should the group means and error bars
be horizontally offset from each other so as not to overlap?
(default = 0.13)}

\item{legend_position}{position of the legend:
\code{"none", "top", "right", "bottom", "left", "none"}
(default = \code{"right"})}
}
\value{
by default, the output will be a ggplot object.
If \code{output = "table"}, the output will be a data.table object.
}
\description{
Creates a plot of sample means and error bars by group.
}
\examples{
plot_group_means(data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"))
plot_group_means(data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"),
error_bar = "se")
plot_group_means(data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"),
error_bar = "pi", error_bar_range = 0.99)
}
