% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_analysis.R
\name{parallel_analysis}
\alias{parallel_analysis}
\title{Parallel analysis}
\usage{
parallel_analysis(
  data = NULL,
  names_of_vars = NULL,
  iterations = NULL,
  percentile_for_eigenvalue = 95
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{names_of_vars}{names of the variables}

\item{iterations}{number of random data sets. If no input is entered,
this value will be set as 30 * number of variables.}

\item{percentile_for_eigenvalue}{percentile used in estimating bias
(default = 95).}
}
\description{
Conducts a parallel analysis to determine how many factors
to retain in a factor analysis.
}
\details{
The following package(s) must be installed prior to running the function:
Package 'paran' v1.5.2 (or possibly a higher version) by
Alexis Dinno (2018),
\url{https://cran.r-project.org/package=paran}
}
\examples{
\donttest{
parallel_analysis(
  data = mtcars, names_of_vars = c("disp", "hp", "drat"))
# parallel_analysis(
# data = mtcars, names_of_vars = c("carb", "vs", "gear", "am"))
}
}
