% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomean.R
\name{geomean}
\alias{geomean}
\title{Geometric mean}
\usage{
geomean(x = NULL, zero_or_neg_convert_to = NA)
}
\arguments{
\item{x}{a numeric vector}

\item{zero_or_neg_convert_to}{the value to which zero or negative
values will be converted to. If \code{zero_or_neg_convert_to == NA},
zero or negative values will be converted to NA values and thus be
excluded when calculating the geometric mean. (default = NA)}
}
\description{
Calculate the geometric mean of a numeric vector
}
\examples{
\dontrun{
geomean(c(1, 4))
geomean(c(1, 100))
geomean(c(1, 100, NA))
geomean(c(1, 100, NA, 0, -1, -2))
geomean(
x = c(1, 100, NA, 0, -1, -2),
zero_or_neg_convert_to = 1)
geomean(c(1, 100, NA, 1, 1, 1))
}
}
