% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglinear_analysis.R
\name{loglinear_analysis}
\alias{loglinear_analysis}
\title{Loglinear analysis}
\usage{
loglinear_analysis(
  data = NULL,
  dv_name = NULL,
  iv_1_name = NULL,
  iv_2_name = NULL,
  iv_1_values = NULL,
  iv_2_values = NULL,
  output = "all",
  round_p = 3,
  round_chi_sq = 2,
  mosaic_plot = TRUE,
  report_as_field = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable}

\item{iv_1_name}{name of the first independent variable}

\item{iv_2_name}{name of the second independent variable}

\item{iv_1_values}{restrict all analyses to observations having
these values for the first independent variable}

\item{iv_2_values}{restrict all analyses to observations having
these values for the second independent variable}

\item{output}{type of the output. If \code{output_type = "all"},
the function will return a results summary and print a mosaic plot.
(default = "all")}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{round_chi_sq}{number of decimal places to which to round
chi-squared test statistics (default = 2)}

\item{mosaic_plot}{If \code{mosaic_plot = TRUE}, a mosaic plot will
be printed (default = TRUE)}

\item{report_as_field}{If \code{report_as_field = TRUE}, reports summary
will follow the format suggested by Andy Field (2012)
(ISBN: 978-1-4462-0045-2, p. 851)}
}
\description{
Conduct a loglinear analysis
}
\examples{
\donttest{
loglinear_analysis(data = data.frame(Titanic), "Survived", "Sex", "Age")
}
}
