% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skm.R
\name{skm}
\alias{skm}
\title{Simple k-medoid algorithm}
\usage{
skm(distdata, ncluster, seeding = 20, iterate = 10)
}
\arguments{
\item{distdata}{A distance matrix (\emph{n x n}) or \emph{dist} object.}

\item{ncluster}{A number of clusters.}

\item{seeding}{A number of seedings to run the algorithm
(\emph{see} \strong{Details}).}

\item{iterate}{A number of iterations for each seeding
(\emph{see} \strong{Details}).}
}
\value{
Function returns a list of components:

\code{cluster} is the clustering memberships result.

\code{medoid} is the id medoids.

\code{minimum_distance} is the distance of all objects to their cluster
medoid.
}
\description{
This function runs the simple k-medoid algorithm
proposed by Budiaji and Leisch (2019).
}
\details{
The simple k-medoids, which sets a set of medoids as the
cluster centers, adapts the simple and fast k-medoid algoritm.
The best practice to run the simple and fast k-medoid is by running
the algorithm several times with different random seeding options.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
result <- skm(mrwdist, ncluster = 3, seeding = 50)
table(result$cluster, iris[,5])


}
\references{
W. Budiaji, and F. Leisch. 2019. Simple K-Medoids Partitioning
Algorithm for Mixed Variable Data. Algorithms Vol 12(9) 177
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
