% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{animated_fixation_plot}
\alias{animated_fixation_plot}
\title{Create GIF animation of fixations on a stimulus images}
\usage{
animated_fixation_plot(
  gazedata,
  xres = 1920,
  yres = 1080,
  plot.onset,
  plot.offset,
  background.images = NA,
  filename = "scanpath.gif",
  save.gif = FALSE,
  gif.dpi = 300,
  gazepoint.size = 2,
  n.loops = 1,
  show.legend = TRUE,
  id_color_map = NA,
  resolution.scaling = 0.5,
  framerate = 10,
  show.progress = TRUE
)
}
\arguments{
\item{gazedata}{Data frame with fixation data which must include columns for x and y coordinates as well as the
variable onset which indicates the onset of the fixation. Make sure the onset variables match the timing  the plot.onset and plot.offset input.
If the categorical or factor variable id is included, separate colors will represent each participant. Make sure the onset variables match the timing  the plot.onset and plot.offset input.}

\item{xres}{horizontal resolution of the screen or area to plot on. Default 1920}

\item{yres}{vertical resolution of the screen or area to plot on. Default 1080}

\item{plot.onset}{Onset of the interval in the gaze_data$onset variable to plot in the same unit, typically milliseconds}

\item{plot.offset}{Offset of the interval in the corresponding to the variable onset in the input data frame gazedata to plot in the same unit, typically milliseconds}

\item{background.images}{data frame with information about background images to use as background. The data frame must include the variables min.x, min.y, max.x, and max.y variables representing
where the images should be placed on the background, the variable path specifying a full file path, and the onset and offset of each image in units corresponding to the time stamps of the gazedata
matrix. Background images should be in JPEG format. This is an example:
 \code{
background.images <- data.frame(
                      min.x = c(100, 800),
                      min.y = c(100, 100),
                      max.x = c(300, 100),
                      max.y = c(600, 600),
                      path = c("~/path_to_image1/image1.jpg", "~/path_to_image1/image2.jpg"),
                      onset = c(1, 4000),
                      offset = c(4000, 6000)}}

\item{filename}{Name of path where the .gif is saved}

\item{save.gif}{If TRUE, save the created .gif file under the name specified in the filename parameter}

\item{gif.dpi}{Resolution in dpi if .gif is saved. Lower values give smaller files.}

\item{gazepoint.size}{Size of marker representing fixation coordinates.}

\item{n.loops}{Specify the number of times to play the plotted sequence. Default is 1. If n.loops is 0, the .gif will play in an eternal loop}

\item{show.legend}{If TRUE, show values of the variable id in legend}

\item{id_color_map}{A character vector with HEX color codes for each id. If \code{NA}, a color map with unique colors for each id is created by the function.
You can create a specific color map for your data using the following code:
new_color_map <-  \code{c("#FB61D7", "#00C094")}
names(new_color_map) <-  \code{c("Id1", "Id2")}}

\item{resolution.scaling}{Scaling of the original images and gaze data. Default is 0.5. Decreasing the size of the images can make the function quicker.
This can be useful if you want to assign specific colors for different groups}

\item{framerate}{Frames per seconds of the returned animation. Default 10}

\item{show.progress}{If TRUE, show progression of the function in the prompt}
}
\value{
a magick animation of raw and fixated values plotted on the y axis and sample number on the x axis
}
\description{
This function plots and returns a .gif showing fixations on a background with one or multiple images, typically the stimuli.
The interval to plot is defined by sample numbers. Fixations must have the variables x, y, and onset. The function works with .jpg images. If paths to multiple images
are given, all will be displayed. Fixations are shown on a white background if no background images are defined. .gif images can be saved to a file.
Gaze data are plotted on a reversed y-axis where x and y are 0 is the upper left corner, corresponding to the structure of data from Tobii eye trackers. If there are multiple participants specified in the
variable id, each participant will get a unique color. You may get an error message if some participants lack data during single frames. This is usually no cause for concern.
}
