% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrartcl.R
\name{scrartcl}
\alias{scrartcl}
\title{Rmarkdown Template for koma-scrartcl}
\usage{
scrartcl(..., number_sections = TRUE,
  md_extensions = c("-autolink_bare_uris"), csl = find_resource("scrartcl",
  "vancouver-brackets.csl"))
}
\arguments{
\item{...}{Arguments passed down to \code{\link[bookdown:pdf_document2]{bookdown::pdf_document2()}}}

\item{number_sections}{Whether to number section headers: if \code{TRUE},
figure/table numbers will be of the form \code{X.i}, where \code{X} is the
current first-level section number, and \code{i} is an incremental number
(the i-th figure/table); if \code{FALSE}, figures/tables will be numbered
sequentially in the document from 1, 2, ..., and you cannot cross-reference
section headers in this case.}

\item{md_extensions}{Arguments to be passed to a
specific output format function. For a function \code{foo2()}, its
arguments are passed to \code{foo()}, e.g. \code{...} of
\code{html_document2()} are passed to \code{rmarkdown::html_document()}.}

\item{csl}{bibliography style in the \code{.csl} format}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}.
}
\description{
This is an interface to the KOMA-Script class scrartcl that acts as an
alternative to the article class in LaTeX. Most of the added functionality
is documented in the \emph{scrartcl} vignette
(\code{vignette("scrartcl", "komadown")}) and is accessed via the YAML metadata
block of the R Markdown file.
}
\examples{

library(rmarkdown)
library(bookdown)
draft("MyArticle.Rmd", template = "scrartcl", package = "komadown",
      edit = FALSE)
}
