% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcovgamma.R
\name{dcov.gamma}
\alias{dcov.gamma}
\title{Test to check the independence between two variables x and y using the Distance Covariance.
The dcov.gamma() function, uses Distance Covariance independence criterion with gamma approximation to test for independence between two random variables.}
\usage{
dcov.gamma(x, y, index = 1, numCol = 100)
}
\arguments{
\item{x}{data of first sample}

\item{y}{data of second sample}

\item{index}{exponent on Euclidean distance, in (0,2]}

\item{numCol}{Number of columns used in incomplete Singular Value Decomposition}
}
\value{
dcov.gamma() returns a list with class htest containing
\item{method}{description of test}
\item{statistic}{observed value of the test statistic}
\item{estimate}{nV^2(x,y)}
\item{estimates}{a vector: [nV^2(x,y), mean of nV^2(x,y), variance of nV^2(x,y)]}
\item{replicates}{replicates of the test statistic}
\item{p.value}{approximate p-value of the test}
\item{data.name}{desciption of data}
}
\description{
Test to check the independence between two variables x and y using the Distance Covariance.
The dcov.gamma() function, uses Distance Covariance independence criterion with gamma approximation to test for independence between two random variables.
}
\details{
Let x and y be two samples of length n. Gram matrices K and L are defined as: \eqn{K_{i,j} = \| x_i-x_j \|^s}{K_{i,j} =|x_i-x_j|^s} and \eqn{L_{i,j} = \| y_i-y_j \|^s}{L_{i,j} =|y_i-y_j|^s}, where 0<s<2. \eqn{H_{i,j} = \delta_{i,j} - \frac{1}{n}}{H_{i,j} = delta_{i,j} - 1/n}. Let A=HKH and B=HLH, then \eqn{nV^2=\frac{1}{n^2}\sum A_{i,j} B_{i,j}}{nV^2 = \sum A_{i,j} B_{i,j} \n^2}. For more detail: \link{dcov.test} in package energy. Gamma test compares \eqn{nV^2_n(x,y)} with the \eqn{\alpha}{alpha} quantile of the gamma distribution with mean and variance same as \eqn{nV^2_n} under independence hypothesis.
}
\examples{
library(energy)
set.seed(10)
#independence
x <- runif(300)
y <- runif(300)

hsic.gamma(x,y)
hsic.perm(x,y)
dcov.gamma(x,y)
dcov.test(x,y)

#uncorelated but not dependent
z <- 10*(runif(300)-0.5)
w <- z^2 + 10*runif(300)

cor(z,w)
hsic.gamma(z,w)
hsic.perm(z,w)
dcov.gamma(z,w)
dcov.test(z,w)
}
\author{
Petras Verbyla (\email{petras.verbyla@mrc-bsu.cam.ac.uk}) and Nina Ines Bertille Desgranges
}
\references{
A. Gretton et al. (2005). Kernel Methods for Measuring Independence. JMLR 6 (2005) 2075-2129.

G. Szekely, M. Rizzo and N. Bakirov (2007). Measuring and Testing Dependence by Correlation of Distances. The Annals of Statistics 2007, Vol. 35, No. 6, 2769-2794.
}
\seealso{
\link{hsic.perm}, \link{hsic.clust}, \link{hsic.gamma}, \link{dcov.test}, \link{kernelCItest}
}

