% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-utils.R
\docType{data}
\name{gsi_tiles}
\alias{gsi_tiles}
\title{Add a tile layer from GSI}
\format{
A 48 length, \link[leaflet:leaflet]{leaflet} objects.
}
\usage{
gsi_tiles
}
\description{
Add a tile layer from Geospatial Information Authority of Japan (GSI).
}
\details{
Stores map tiles that can be used with leaflets.
Please follow the terms and conditions of use for the applicable tile at
\url{http://maps.gsi.go.jp/development/ichiran.html}
when using it.
It contains tiles that can be used as base maps for interactive maps based on leaflet.
See example section its use in leaflet. To use a mapview,
a tile name is given to \code{mapview::mapview(map = )}.
}
\examples{
names(gsi_tiles)
require("leaflet")
gsi_tiles[[1]]

gsi_tiles[[1]] \%>\%
  addCircles(
    data = sf::st_transform(extreme_points \%>\%
      purrr::reduce(c),
      crs = 4326))
}
\keyword{datasets}
