% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_val_labs.R
\name{sort_val_labs}
\alias{sort_val_labs}
\title{Sort Ascending Any Variable Value Labels}
\usage{
sort_val_labs(data)
}
\arguments{
\item{data}{a data.frame}
}
\value{
a data.frame
}
\description{
\code{sort_val_labs} sorts the presentation order of variable value label meta-data.
}
\details{
This function is used in internally by other labelr functions to ensure that
value label meta-data is sorted in a logical, intuitive order. It is not
intended for interactive use.
}
\examples{
# note that this example is trivial, as value labels already are in order
df <- mtcars
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

df <- sort_val_labs(df)
}
