% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_likert_data.R
\name{make_likert_data}
\alias{make_likert_data}
\title{Construct a Fake Likert Survey Response Data Frame}
\usage{
make_likert_data(n = 1000, scale = 1:7, rownames = TRUE)
}
\arguments{
\item{n}{number of observations (rows) of hypothetical data set to create.}

\item{scale}{the sequence of distinct integer values describing the raw /
naive numerical codings of Likert-type survey items.}

\item{rownames}{create memorable but arbitrary rownames for inspection (if
TRUE).}
}
\value{
a data.frame.
}
\description{
\code{make_likert_data} generates a data.frame with select (entirely fictional)
numerically coded responses of fictional people to fictional survey items to
demonstrate and explore labelr functionalities.
}
\details{
Data is entirely fictional and strictly for purposes of demonstrating labelr.
}
\examples{
# add_val_labs() "vars" arg will do partial matching if partial = TRUE
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("x", "y3"), # note the vars args
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

# note, all "x" vars get the labs, as does "y3"
# see vars = args above
lik1 <- use_val_labs(dflik)
head(lik1)
}
