% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbpto.R
\name{rbpto}
\alias{rbpto}
\alias{bpto.coverageprob}
\alias{bpto.germintensity}
\alias{bpto.covar}
\title{Simulate Boolean Model with Grains Scaled According to a Truncated
Pareto Distribution}
\usage{
rbpto(lambda, grain, win, xm, alpha, lengthscales, seed = NULL, xy = NULL)

bpto.coverageprob(lambda, grain, xm, alpha, lengthscales = 1:500)

bpto.germintensity(coverp, grain, xm, alpha, lengthscales = 1:500)

bpto.covar(lambda, grain, xm, alpha, lengthscales = 1:500, xy)
}
\arguments{
\item{lambda}{Intensity of the germ process (which is a Poisson point
process)}

\item{grain}{A single \code{owin} object that gives the shape and size of the grain
at scale 1}

\item{win}{The window to simulate in (an \code{owin} object)}

\item{xm}{A parameter governing the shape of the Pareto distribution used -
see details}

\item{alpha}{A parameter governing the shape of the Pareto distribution used
\itemize{
\item see details
}}

\item{lengthscales}{A list of scales of the \code{grain} for which to
approximate the Pareto distribution: The grain for a germ is chosen by
selecting a scaled version of \code{grain} where \code{lengthscales}
specifies the possible scales and the Pareto distribution is used to
specify the probability of selection of each scale.}

\item{seed}{Optional input (default in NULL). Is an integer passed to
\code{\link[base]{set.seed}}. Used to reproduce patterns exactly.}

\item{xy}{A raster object that specifies pixel coordinates of the final
simulated binary map. It is used the same way as \code{xy} is
\code{\link[spatstat.geom]{as.mask}} in \pkg{spatstat}. If non-null then the
computations will be performed using rasters. Otherwise if \code{grain} and
\code{win} are polygonal then computations may be all polygonal.}

\item{coverp}{Coverage probability of the Boolean model.}
}
\value{
An \code{owin} object.
}
\description{
Functions for simulation and computing theoretical values of a
Boolean model with identically shaped grains with size given by a
truncated Pareto distribution.
}
\details{
The parameters \code{xm} and \code{alpha} are such that the CDF of the Pareto distribution is \eqn{P(s <= x) = 1 - (xm / x)^{alpha}}.
The distribution of grains scales is a step-function approximation to the CDF with steps at \code{lengthscales}.
}
\section{Functions}{
\itemize{
\item \code{rbpto}: Simulate Boolean model with grain size distributed according to a truncated Pareto distribution.

\item \code{bpto.coverageprob}: The coverage probability of the Boolean model with grain size distributed according to a truncated Pareto distribution.

\item \code{bpto.germintensity}: The germ intensity of the Boolean model with grain size distributed according to a truncated Pareto distribution.

\item \code{bpto.covar}: The covariance of the Boolean model with grain size distributed according to a truncated Pareto distribution.
\code{xy} is required to specify resolution and offset of pixel grid.
}}

\examples{
lambda <- 0.2
win <- square(r = 10)
grain <- disc(r = 0.2)
xm <- 0.01
alpha <- 2
lengthscales <- seq(1, 5, by = 0.1)
xi <- rbpto(lambda, grain, win, xm, alpha, lengthscales = lengthscales)

# Compute properties of the Boolean model from parameters
bpto.coverageprob(lambda, grain, xm, alpha, lengthscales = lengthscales)
covar <- bpto.covar(lambda, grain, xm, alpha, lengthscales = lengthscales,
                    xy = as.mask(win, eps = 2))
}
\keyword{datagen}
\keyword{spatial}
