% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{lac_plot}
\alias{lac_plot}
\alias{lacnorm_plot}
\alias{hr_plot}
\title{Plot lacunarity curve(s)}
\usage{
lac_plot(..., log = TRUE, group_names = NULL)

lacnorm_plot(..., log = TRUE, group_names = NULL)

hr_plot(..., group_names = NULL)
}
\arguments{
\item{...}{One or more \code{\link[=data.frame]{data.frames}} containing lacunarity
curve data. Must contain columns named \verb{$box_size}, \verb{$lacunarity},
\verb{$lac_norm}, and \verb{$H_r}.}

\item{log}{A Boolean. \code{TRUE} (default) displays the axes on a logarithmic
scale, \code{FALSE} displays them on a linear scale. For \code{lacnorm_plot()} this
only controls the x axis, as normalized lacunarity is by definition on a
log scale.}

\item{group_names}{A character \code{\link[=vector]{vector}} containing labels for any
data.frames passed to \code{...}. These labels will appear on the plot legend.
If \code{group_names} is left empty, the legend uses the names of the
data.frames as supplied to \code{...}}
}
\value{
A \code{ggplot} object displaying the lacunarity or H(r) curve(s). If
multiple curves are supplied, their ordering in the plot legend will
reflect the order they were listed in the function call.
}
\description{
Plot lacunarity curve(s)
}
\examples{
# generate array
a <- array(data = rep(c(1,0), 125), dim = c(5,5,5))
# calculate lacunarity at all box sizes
lac_curve <- lacunarity(a, box_sizes = "all")
# plot raw lacunarity curve
lac_plot(lac_curve)

}
