% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{prop}
\alias{prop}
\title{Proportion of an alternative distribution}
\usage{
prop(bin, weights = NULL, sort = NULL, years = NULL,
  breakdown = NULL, design = NULL, cluster = NULL, data = NULL,
  var = NULL, alpha = 0.05, na.rm = FALSE, ...)
}
\arguments{
\item{bin}{either a factor vector giving the values,
or (if \code{data} is not \code{NULL}) a character string, an integer or a
logical vector specifying the corresponding column of \code{data}.}

\item{weights}{optional; either a numeric vector giving the personal sample
weights, or (if \code{data} is not \code{NULL}) a character string, an
integer or a logical vector specifying the corresponding column of
\code{data}.}

\item{sort}{optional; either a numeric vector giving the personal IDs to be
used as tie-breakers for sorting, or (if \code{data} is not \code{NULL}) a
character string, an integer or a logical vector specifying the corresponding
column of \code{data}.}

\item{years}{optional; either a numeric vector giving the different years of
the survey, or (if \code{data} is not \code{NULL}) a character string, an
integer or a logical vector specifying the corresponding column of
\code{data}.  If supplied, values are computed for each year.}

\item{breakdown}{optional; either a numeric vector giving different domains,
or (if \code{data} is not \code{NULL}) a character string, an integer or a
logical vector specifying the corresponding column of \code{data}.  If
supplied, the values for each domain are computed in addition to the overall
value.}

\item{design}{optional and only used if \code{var} is not \code{NULL}; either
an integer vector or factor giving different domains for stratified sampling
designs, or (if \code{data} is not \code{NULL}) a character string, an
integer or a logical vector specifying the corresponding column of
\code{data}.}

\item{cluster}{optional and only used if \code{var} is not \code{NULL};
either an integer vector or factor giving different clusters for cluster
sampling designs, or (if \code{data} is not \code{NULL}) a character string,
an integer or a logical vector specifying the corresponding column of
\code{data}.}

\item{data}{an optional \code{data.frame}.}

\item{var}{a character string specifying the type of variance estimation to
be used, or \code{NULL} to omit variance estimation.  See
\code{\link{variance}} for possible values.}

\item{alpha}{numeric; if \code{var} is not \code{NULL}, this gives the
significance level to be used for computing the confidence interval (i.e.,
the confidence level is \eqn{1 - }\code{alpha}).}

\item{na.rm}{a logical indicating whether missing values should be removed.}

\item{\dots}{if \code{var} is not \code{NULL}, additional arguments to be
passed to \code{\link{variance}}.}
}
\value{
A list of class \code{"prop"} (which inherits from the class
\code{"indicator"}) with the following components:
\item{value}{a numeric vector containing the overall value(s).}
\item{valueByStratum}{a \code{data.frame} containing the values by
domain, or \code{NULL}.}
\item{varMethod}{a character string specifying the type of variance
estimation used, or \code{NULL} if variance estimation was omitted.}
\item{var}{a numeric vector containing the variance estimate(s), or
\code{NULL}.}
\item{varByStratum}{a \code{data.frame} containing the variance
estimates by domain, or \code{NULL}.}
\item{ci}{a numeric vector or matrix containing the lower and upper
endpoints of the confidence interval(s), or \code{NULL}.}
\item{ciByStratum}{a \code{data.frame} containing the lower and upper
endpoints of the confidence intervals by domain, or \code{NULL}.}
\item{alpha}{a numeric value giving the significance level used for
computing the confidence interval(s) (i.e., the confidence level is \eqn{1 -
}\code{alpha}), or \code{NULL}.}
\item{years}{a numeric vector containing the different years of the
survey.}
\item{strata}{a character vector containing the different domains of the
breakdown.}
}
\description{
Estimate the proportion of an alternative distribution.
}
\details{
If weights are provided, the weighted proportion is estimated.
}
\examples{
data(eusilc)

# overall value
prop("rb090", weights = "rb050", data = eusilc)

# values by region
p1 <- prop("rb090", weights = "rb050",
    breakdown = "db040",  cluster = "db030",
    data = eusilc)

p1

\dontrun{
variance("rb090", weights = "rb050",
    breakdown = "db040", data = eusilc, indicator=p1,
    cluster="db030", X = calibVars(eusilc$db040))
}


eusilc$agecut <- cut(eusilc$age, 2)
p1 <- prop("agecut", weights = "rb050",
           breakdown = "db040",
           cluster="db030", data = eusilc)
p1

\dontrun{
variance("agecut", weights = "rb050",
         breakdown = "db040", data = eusilc, indicator=p1,
         X = calibVars(eusilc$db040), cluster="db030")
}


eusilc$eqIncomeCat <- factor(ifelse(eusilc$eqIncome < quantile(eusilc$eqIncome,0.2), "one", "two"))
p1 <- prop("eqIncomeCat", weights = "rb050",
           breakdown = "db040", data = eusilc, cluster="db030")
p1

\dontrun{
variance("eqIncomeCat", weights = "rb050",
         breakdown = "db040", data = eusilc, indicator=p1,
         X = calibVars(eusilc$db040), cluster="db030")
}


}
\references{
A. Alfons and M. Templ (2013) Estimation of Social Exclusion Indicators
from Complex Surveys: The \R Package \pkg{laeken}.  \emph{Journal of
Statistical Software}, \bold{54}(15), 1--25.  URL
\url{http://www.jstatsoft.org/v54/i15/}

Working group on Statistics on Income and Living Conditions (2004)
Common cross-sectional EU indicators based on EU-SILC; the gender
pay gap.  \emph{EU-SILC 131-rev/04}, Eurostat, Luxembourg.
}
\seealso{
\code{\link{variance}}
}
\author{
Matthias Templ, using code for breaking down
estimation by Andreas Alfons
}
\keyword{survey}
