% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_pd.R
\name{lsm_c_pd}
\alias{lsm_c_pd}
\alias{lsm_c_pd.RasterLayer}
\alias{lsm_c_pd.RasterStack}
\alias{lsm_c_pd.RasterBrick}
\alias{lsm_c_pd.list}
\title{PD (class level)}
\usage{
lsm_c_pd(landscape, directions)

\method{lsm_c_pd}{RasterLayer}(landscape, directions = 8)

\method{lsm_c_pd}{RasterStack}(landscape, directions = 8)

\method{lsm_c_pd}{RasterBrick}(landscape, directions = 8)

\method{lsm_c_pd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch density (Aggregation metric)
}
\details{
\deqn{PD = \frac{n_{i}} {A} * 10000 * 100}
where \eqn{n_{i}} is the number of patches and \eqn{A} is the total landscape
area in square meters.

PD is an 'Aggregation metric'. It describes the fragmentation of a class, however, does not
necessarily contain information about the configuration or composition of the class. In
contrast to \code{\link{lsm_c_np}} it is standardized to the area and comparisons among
landscapes with different total area are possible.

\subsection{Units}{Number per 100 hectares}
\subsection{Ranges}{0 < PD <= 1e+06}
\subsection{Behaviour}{Increases as the landscape gets more patchy. Reaches its maximum
if every cell is a different patch.}
}
\examples{
lsm_c_pd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_c_np}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_l_pd}}
}
