% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_lsm.R
\name{window_lsm}
\alias{window_lsm}
\alias{window_lsm.RasterLayer}
\alias{window_lsm.RasterStack}
\alias{window_lsm.RasterBrick}
\alias{window_lsm.stars}
\alias{window_lsm.list}
\title{window_lsm}
\usage{
window_lsm(landscape, window, what, level, metric, name, type, directions,
  count_boundary, consider_boundary, edge_depth, classes_max,
  neighbourhood, ordered, base)

\method{window_lsm}{RasterLayer}(landscape, window, what = NULL,
  level = NULL, metric = NULL, name = NULL, type = NULL,
  directions = 8, count_boundary = FALSE, consider_boundary = FALSE,
  edge_depth = 1, classes_max = NULL, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{window_lsm}{RasterStack}(landscape, window, what = NULL,
  level = NULL, metric = NULL, name = NULL, type = NULL,
  directions = 8, count_boundary = FALSE, consider_boundary = FALSE,
  edge_depth = 1, classes_max = NULL, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{window_lsm}{RasterBrick}(landscape, window, what = NULL,
  level = NULL, metric = NULL, name = NULL, type = NULL,
  directions = 8, count_boundary = FALSE, consider_boundary = FALSE,
  edge_depth = 1, classes_max = NULL, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{window_lsm}{stars}(landscape, window, what = NULL,
  level = NULL, metric = NULL, name = NULL, type = NULL,
  directions = 8, count_boundary = FALSE, consider_boundary = FALSE,
  edge_depth = 1, classes_max = NULL, neighbourhood = 4,
  ordered = TRUE, base = "log2")

\method{window_lsm}{list}(landscape, window, what = NULL, level = NULL,
  metric = NULL, name = NULL, type = NULL, directions = 8,
  count_boundary = FALSE, consider_boundary = FALSE, edge_depth = 1,
  classes_max = NULL, neighbourhood = 4, ordered = TRUE,
  base = "log2")
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{window}{matrix}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_c_ca", "lsm_l_ta")}.}

\item{level}{Level of metrics to calculate (e.g. 'landscape').}

\item{metric}{Abbreviation of metrics to calculate (e.g. 'area').}

\item{name}{Full name of metrics to calculate (e.g. 'core area').}

\item{type}{Metric types to calculate according to FRAGSTATS grouping (e.g. 'aggregation metric').}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{count_boundary}{Include landscape boundary in edge length}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}

\item{classes_max}{Potential maximum number of present classes}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered. Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}

\item{base}{The unit in which entropy is measured. The default is "log2",
which compute entropy in "bits". "log" and "log10" can be also used.}
}
\value{
list
}
\description{
Moving window
}
\details{
The function calculates for each focal cell the selected landscape metrics (currently only landscape level
metrics are allowed) for a local neighbourhood. The neighbourhood can be specified using a matrix. For more
details, see \code{?raster::focal()}. The result will be a \code{RasterLayer} in which each focal cell includes
the value of its neighbourhood and thereby allows to show gradients and variability in the landscape (Hagen-Zanker 2016).
To be type stable, the acutally result is always a nested list (first level for \code{RasterStack} layers, second level
for selected landscape metrics).
}
\examples{
\dontrun{
window <- matrix(1, nrow = 5,ncol = 5)
window_lsm(landscape, window = window, what = c("lsm_l_pr", "lsm_l_joinent"))
window_lsm(landscape_stack, window = window, what = c("lsm_l_pr", "lsm_l_joinent"))
}

}
\references{
Fletcher, R., Fortin, M.-J. 2018. Spatial Ecology and Conservation Modeling: Applications
with R. Springer International Publishing. 523 pages

Hagen-Zanker, A. (2016). A computational framework for generalized moving windows
and its application to landscape pattern analysis. International journal of applied
earth observation and geoinformation, 44, 205-216.

McGarigal, K., Cushman, S.A., and Ene E. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
website: \url{http://www.umass.edu/landeco/research/fragstats/fragstats.html}
}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{focal}}
}
