% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_np.R
\name{lsm_l_np}
\alias{lsm_l_np}
\title{NP (landscape level)}
\usage{
lsm_l_np(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Number of patches (Aggregation metric)
}
\details{
\deqn{NP = N}
where \eqn{N} is the number of patches.

NP is an 'Aggregation metric'. It describes the fragmentation of the landscape,
however, does not necessarily contain information about the configuration or
composition of the landscape.

\subsection{Units}{None}
\subsection{Ranges}{NP >= 1}
\subsection{Behaviour}{Equals NP = 1 when only one patch is present and
increases, without limit, as the number of patches increases}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_np(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_c_np}}
}
