% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_frac_mn.R
\name{lsm_l_frac_mn}
\alias{lsm_l_frac_mn}
\title{FRAC_MN (landscape level)}
\usage{
lsm_l_frac_mn(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean fractal dimension index (Shape metric)
}
\details{
\deqn{FRAC_{MN} = mean(FRAC[patch_{ij}])}
where \eqn{FRAC[patch_{ij}]} equals the fractal dimension index of each patch.

FRAC_MN is a 'Shape metric'. The metric summarises the landscape
as the mean of the fractal dimension index of all patches in the landscape.
The fractal dimension index is based on the patch perimeter and
the patch area and describes the patch complexity. The Coefficient of variation is
scaled to the mean and comparable among different landscapes.

\subsection{Units}{None}
\subsection{Range}{FRAC_MN > 0 }
\subsection{Behaviour}{Approaches FRAC_MN = 1 if all patches are squared and FRAC_MN = 2
if all patches are irregular.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_frac_mn(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Mandelbrot, B. B. 1977. Fractals: Form, Chance, and Dimension.
San Francisco. W. H. Freeman and Company.
}
\seealso{
\code{\link{lsm_p_frac}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_frac_mn}},
\code{\link{lsm_c_frac_sd}},
\code{\link{lsm_c_frac_cv}}, \cr
\code{\link{lsm_l_frac_sd}},
\code{\link{lsm_l_frac_cv}}
}
