% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/langevitour.R
\name{langevitour}
\alias{langevitour}
\title{Langevin Tour}
\usage{
langevitour(
  X,
  group = NULL,
  name = NULL,
  center = NULL,
  scale = NULL,
  extraAxes = NULL,
  axisColors = NULL,
  pointSize = 1,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{X}{The data to plot. A matrix of numeric data, or something that can be cast to a matrix. Rows will be shown as points in the widget. Columns are the variables of your data.}

\item{group}{A group for each row in X, will be used to color points. A factor, or something that can be cast to a factor.}

\item{name}{A name for each row in X.}

\item{center}{Center for each variable. If omitted, the column means will be used.}

\item{scale}{Scale for each variable. Scale +/- center will be the range of guaranteed visible data. If omitted, a reasonable default will be chosen, equal for all variables. (The default is the largest singular value of the centered X times 2.5.)}

\item{extraAxes}{A matrix with each column defining a projection of interest. The columns of \code{X \%*\% extraAxes} will be presented as extra "variables".}

\item{axisColors}{Character vector. Colors for each variable and then each extra axis.}

\item{pointSize}{Point radius in pixels.}

\item{width}{Width of widget.}

\item{height}{Height of widget.}

\item{elementId}{An element ID for the widget, see htmlwidgets::createWidget.}
}
\value{
An htmlwidget object.
}
\description{
Make a Langevin Tour HTML widget, which can be used to explore high-dimensional numeric datasets.
}
\details{
To retain the original units on plot axes within the widget, use \code{center} and \code{scale} rather than altering X.

langevitour will by default not scale variables individually. If you want this, use something like \code{scale=apply(X,2,sd)*4}.
}
\examples{
library(palmerpenguins)

completePenguins <- na.omit(penguins[,c(1,3,4,5,6)])
scale <- apply(completePenguins[,-1], 2, sd)*4

langevitour(
    completePenguins[,-1], 
    completePenguins$species, 
    scale=scale, pointSize=2)

}
