% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/langevitour.R
\name{langevitour}
\alias{langevitour}
\title{Langevin Tour}
\usage{
langevitour(
  X,
  group = NULL,
  name = NULL,
  center = NULL,
  scale = NULL,
  extraAxes = NULL,
  lineFrom = NULL,
  lineTo = NULL,
  axisColors = NULL,
  levelColors = NULL,
  colorVariation = 0.3,
  pointSize = 1,
  subsample = NULL,
  state = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{X}{The data to plot. A matrix of numeric data, or something that can be cast to a matrix. Rows will be shown as points in the widget. Columns are the variables of your data.}

\item{group}{A group for each row in X, will be used to color points. A factor, or something that can be cast to a factor.}

\item{name}{A name for each row in X.}

\item{center}{Center for each variable. If omitted, the column means will be used.}

\item{scale}{Scale for each variable. Scale +/- center will be the range of guaranteed visible data. If omitted, a reasonable default will be chosen, equal for all variables. (The default is the largest singular value of the centered X times 2.5.)}

\item{extraAxes}{A matrix with each column defining a projection of interest. The columns of \code{X \%*\% extraAxes} will be presented as extra "variables".}

\item{lineFrom}{A vector of row numbers. Draw lines starting at these rows.}

\item{lineTo}{A vector of row numbers. Draw lines ending at these rows.}

\item{axisColors}{Character vector. Colors for each variable and then each extra axis.}

\item{levelColors}{Character vector. Colors for each level of \code{group}.}

\item{colorVariation}{Number between 0 and 1. Individual points are given slightly different brightnesses. How strong should this effect be?}

\item{pointSize}{Point radius in pixels.}

\item{subsample}{For speed, randomly subsample down to this many rows.}

\item{state}{A JSON string, or an object that htmlwidgets will convert to the correct JSON. Initial widget state settings. The state of a widget can be obtained by pressing the "?" button. I am not going to guarantee that states will be compatible between versions of langevitour.}

\item{width}{Width of widget.}

\item{height}{Height of widget.}

\item{elementId}{An element ID for the widget, see htmlwidgets::createWidget.}
}
\value{
An htmlwidget object.
}
\description{
Make a Langevin Tour HTML widget, which can be used to explore high-dimensional numeric datasets.
}
\details{
To retain the original units on plot axes within the widget, use \code{center} and \code{scale} rather than altering X.

langevitour will by default not scale variables individually. If you want variables to be individually scaled, use something like \code{scale=apply(X,2,sd)*4}.

In Javascript, the langevitour object can be obtained using \code{document.getElementById(elementId).langevitour}. For example you could have a button that sets the state of a widget using \code{document.getElementById(elementId).langevitour.setState(desiredState)}.
}
\examples{
library(palmerpenguins)

completePenguins <- na.omit(penguins[,c(1,3,4,5,6)])
scale <- apply(completePenguins[,-1], 2, sd)*4

langevitour(
    completePenguins[,-1], 
    completePenguins$species, 
    scale=scale, pointSize=2)

}
