% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{splot_change}
\alias{splot_change}
\title{Portfolio Plots: Daily Change}
\usage{
splot_change(
  p,
  s,
  weighted = TRUE,
  group = FALSE,
  n_days = 365,
  keep_old = FALSE,
  save = FALSE
)
}
\arguments{
\item{p}{Dataframe. Result from \code{daily_portfolio()}}

\item{s}{Dataframe. Result from \code{daily_stocks()}}

\item{weighted}{Boolean. Should variation values be weighted to the
portfolio (or simply compared with value since inception)?}

\item{group}{Boolean. Group stocks by stocks type?}

\item{n_days}{Integer. How many days back you want to see?
sold entirely?}

\item{keep_old}{Boolean. Include sold tickers even though not currently in portfolio?}

\item{save}{Boolean. Save plot into a local file?}
}
\value{
ggplot object
}
\description{
This function plots each stock's change through history, since
inception, with weighted attributions or absolute values.
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}

Other Investment Plots: 
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()}
}
\concept{Investment}
\concept{Investment Plots}
